﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace VIRP.EFR.DAL
{
    public class CommonManager : DBUtils
    {
        public List<STD_GUI_CONTROL> GetAllStdGuiControls()
        {
            //if (RegistriesGlobal.StdGuiControlAll == null)
            //{
            EFRDB2DataContext efrContext = GetEfr2DataContext();

            var stdGuiControlAll = (from e in efrContext.STD_GUI_CONTROLs
                                    orderby e.SORT_ORDER
                                    select e).ToList();
            efrContext.Dispose();
            //}

            return stdGuiControlAll;
        }

        /// <summary>
        /// Get STD_GUI_CONTROL records by category and registry
        /// </summary>
        /// <param name="category"></param>
        /// <param name="registryId"></param>
        /// <returns></returns>
        public List<STD_GUI_CONTROL> GetStdGuiControlsByCategory(string category, int registryId)
        {
            return (from e in GetAllStdGuiControls()
                    where e.CATEGORY == category
                        && e.STD_REGISTRY_ID == registryId
                    select e).ToList();
        }
    }
}
